<?php

namespace App\Contracts;

abstract class BasePlugin
{
    protected $path;
    protected $manifest;

    public function __construct($path, $manifest)
    {
        $this->path = $path;
        $this->manifest = $manifest;
        
        $this->boot();
    }

    /**
     * Boot method called when plugin is instantiated
     * Override this in your plugin class
     */
    abstract public function boot();

    /**
     * Get the plugin's installation path
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * Get the plugin's manifest data
     */
    public function getManifest()
    {
        return $this->manifest;
    }

    /**
     * Get plugin name from manifest
     */
    public function getName()
    {
        return $this->manifest['name'] ?? 'Unknown';
    }

    /**
     * Get plugin version from manifest
     */
    public function getVersion()
    {
        return $this->manifest['version'] ?? '1.0.0';
    }

    /**
     * Get plugin namespace from manifest
     */
    public function getNamespace()
    {
        return $this->manifest['namespace'] ?? 'Plugins\\' . $this->getName();
    }
}